/******************************************************************************/
#include "stdafx.h"
/******************************************************************************/
Actor ground,
      box   ,
      ball  ;
Cloth cloth ; // Physical Cloth
/******************************************************************************/
void InitPre()
{
   App.name="Physical Clothes";
   App.flag=APP_MS_EXCLUSIVE;
   PakAdd("../data/engine.pak");
   D.mode(1024,768).sync(true);
}
Bool Init()
{
   Cam.dist =4;
   Cam.pitch=-PI_4;

   Physics.create();

   ground.create(Box (15,1,15,Vec(0 ,-2,0)), 0);
   box   .create(Box (0.3    ,Vec(-1, 0,0)));
   ball  .create(Ball(0.3    ,Vec( 1, 0,0)));

   // create cloth
   Cloth::Param param; // parameters for cloth creation
   Mshb         mshb ; // clothes are created from meshes, so create a mesh for it
   mshb .createPlane(32,32,VTX_TX0)                                         // create mesh as 32x32 vertex plane with texture coordinates set
        .matrix(Matrix().setRotateX(PI_2).move(Vec(-0.5,1,-0.5)).scale(3)); // transform mesh by matrix
   cloth.create(mshb,Materials("../data/mtrl/ground/0.mtrl"),param);        // create cloth from mesh

   return true;
}
/******************************************************************************/
void Shut()
{
}
/******************************************************************************/
Bool Main()
{
   if(Kb.bp(KB_ESC))return false;
   CamHandle(0.1,10,CAMH_ZOOM|(Ms.b(1)?CAMH_MOVE:CAMH_ROT));
   Physics.sim().get();
   return true;
}
/******************************************************************************/
void Draw()
{
   LightDir(1,Cam.matrix.z).set();
   D      .clear();
   Physics.draw ();
   cloth  .draw (); // draw cloth
}
/******************************************************************************/
